import csv
import time
import random
import numpy as np
from colorama import Fore

n = 100000  # Number of simulations
# Open the CSV file

with open('sample.csv', 'r', encoding='utf-8-sig') as file:
    # Create a DictReader object
    reader = csv.DictReader(file)
    # Convert to list of dictionaries
    data = list(reader)

# Calculate turnover & actual profit
# Calculate turnover & actual profit
turnover = 0
sum_actual_profit = 0
actual_peak = 0
actual_mdd = 0
for row in data:
    delta = float(row['PROFIT'])
    sum_actual_profit += delta
    turnover += float(row['STAKE'])
    if sum_actual_profit > actual_peak:
        actual_peak = sum_actual_profit
    dd = actual_peak - sum_actual_profit
    if dd > actual_mdd:
        actual_mdd = dd

# Let's run some Monte Carlo simulations
start_time = time.time()
sim_profits = list()
sim_mdds = list()
for i in range(n):
    sim_profit = 0
    peak = 0
    max_dd = 0
    for row in data:
        r = random.random()
        if r <= 1 / float(row['TCLS']):
            delta = float(row['STAKE']) * (float(row['ODDS']) - 1)
        else:
            delta = -float(row['STAKE'])
        sim_profit += delta
        if sim_profit > peak:
            peak = sim_profit
        dd = peak - sim_profit
        if dd > max_dd:
            max_dd = dd
    sim_profits.append(sim_profit)
    sim_mdds.append(max_dd)

runtime = time.time() - start_time

# Compute quartiles
q1 = np.percentile(sim_profits, 25)
q2 = np.percentile(sim_profits, 50)
q3 = np.percentile(sim_profits, 75)

# Compute likelihood of profit being worse than actual profit
count_pl = len([x for x in sim_profits if x < sum_actual_profit])

# Compute likelihood of drawdown being worse than actual drawdown
count_dd = len([x for x in sim_mdds if x > actual_mdd])

print(f"{Fore.LIGHTWHITE_EX}Bets: {Fore.WHITE}{len(data)}")
print(f"{Fore.LIGHTWHITE_EX}Turnover: {Fore.WHITE}{int(turnover)}")
print(f"{Fore.LIGHTWHITE_EX}Actual Profit: {(Fore.RED if sum_actual_profit < 0 else Fore.GREEN)}{int(sum_actual_profit)}")
print(f"{Fore.LIGHTWHITE_EX}Actual ROI: {(Fore.RED if sum_actual_profit / turnover < 0 else Fore.GREEN)}{round(100 * sum_actual_profit / turnover, 2)}%")
print(f"{Fore.LIGHTWHITE_EX}Actual maximum drawdown: {Fore.RED}-{int(actual_mdd)}")
print(f"\n{Fore.LIGHTWHITE_EX}Ran Monte Carlo simulation with {Fore.MAGENTA}{n} {Fore.LIGHTWHITE_EX}iterations in {Fore.MAGENTA}{round(runtime, 1)} {Fore.LIGHTWHITE_EX}seconds.")
print(f"\n{Fore.LIGHTWHITE_EX}Median simulation Profit/ROI: {(Fore.RED if np.median(sim_profits) < 0 else Fore.GREEN)}{int(np.median(sim_profits))} {Fore.WHITE}/ {(Fore.RED if np.median(sim_profits) < 0 else Fore.GREEN)}{round(100 * np.median(sim_profits) / turnover, 2)}%")
print(f"{Fore.LIGHTWHITE_EX}Worst result: {(Fore.RED if min(sim_profits) < 0 else Fore.GREEN)}{int(min(sim_profits))} {Fore.WHITE}/ {(Fore.RED if min(sim_profits) < 0 else Fore.GREEN)}{round(100 * min(sim_profits) / turnover, 2)}%")
print(f"{Fore.LIGHTWHITE_EX}Best result: {(Fore.RED if max(sim_profits) < 0 else Fore.GREEN)}{int(max(sim_profits))} {Fore.WHITE}/ {(Fore.RED if max(sim_profits) < 0 else Fore.GREEN)}{round(100 * max(sim_profits) / turnover, 2)}%")

print(f"\n{Fore.LIGHTWHITE_EX}Median maximum drawdown: {Fore.RED}-{int(np.median(sim_mdds))}")
print(f"{Fore.LIGHTWHITE_EX}Worst maximum drawdown: {Fore.RED}-{int(max(sim_mdds))}")
print(f"{Fore.LIGHTWHITE_EX}Best maximum drawdown: {Fore.RED}-{int(min(sim_mdds))}")

print(f"\n{Fore.LIGHTWHITE_EX}Ending up with a profit of {(Fore.RED if sum_actual_profit < 0 else Fore.GREEN)}{int(sum_actual_profit)} {Fore.LIGHTWHITE_EX}or less has a {Fore.MAGENTA}{round(100 * count_pl / n, 2)}% {Fore.LIGHTWHITE_EX}chance.")
print(f"{Fore.LIGHTWHITE_EX}Having a {Fore.RED}-{int(actual_mdd)} {Fore.LIGHTWHITE_EX}drawdown or worse has a {Fore.MAGENTA}{round(100 * count_dd / n, 2)}% {Fore.LIGHTWHITE_EX}chance.")

print(f"\n{Fore.LIGHTWHITE_EX}There is a {Fore.MAGENTA}25% {Fore.LIGHTWHITE_EX}chance your profit is less than {(Fore.RED if q1 < 0 else Fore.GREEN)}{int(q1)}")
print(f"{Fore.LIGHTWHITE_EX}There is a {Fore.MAGENTA}25% {Fore.LIGHTWHITE_EX}chance your profit is between {(Fore.RED if q1 < 0 else Fore.GREEN)}{int(q1)} {Fore.LIGHTWHITE_EX}and {(Fore.RED if q2 < 0 else Fore.GREEN)}{int(q2)}")
print(f"{Fore.LIGHTWHITE_EX}There is a {Fore.MAGENTA}25% {Fore.LIGHTWHITE_EX}chance your profit is between {(Fore.RED if q2 < 0 else Fore.GREEN)}{int(q2)} {Fore.LIGHTWHITE_EX}and {(Fore.RED if q3 < 0 else Fore.GREEN)}{int(q3)}")
print(f"{Fore.LIGHTWHITE_EX}There is a {Fore.MAGENTA}25% {Fore.LIGHTWHITE_EX}chance your profit is more than {(Fore.RED if q3 < 0 else Fore.GREEN)}{int(q3)}")
